function getFriends(merc)
	local m = Mercs
	local f1 = {}
	local f2 = {}
	local bool1 = false
	local bool2 = false
	
	local getFriend = function(name, data)
		if ((data.hired == true) and (data.alive == true)) then
			if (data.friend1 == merc) then
				bool1 = true
				table.insert(f1, name)
			elseif (data.friend2 == merc) then
				bool2 = true
				table.insert(f2, name)
			end
		end
	end
	
	table.foreach(m, getFriend)
	
	return f1, f2, bool1, bool2

end

function getBuddies(merc)
	local m = Mercs
	local b = {}
	local bool = false
	
	local getBuddy = function(name, data)
		if ((data.hired == true) and (data.alive == true)) then
			if (data.buddy == merc) then
				bool = true
				table.insert(b, name)
			end
		end
	end
	
	table.foreach(m, getBuddy)
	
	return b, bool

end

function getNonFriends(merc)
	local m = Mercs
	local nf1 = {}
	local nf2 = {}
	local bool1 = false
	local bool2 = false
	
	local getNonFriend = function(name, data)
		if ((data.hired == true) and (data.alive == true)) then
			if (data.nonfriend1 == merc) then
				bool1 = true
				table.insert(nf1, name)
			elseif (data.nonfriend2 == merc) then
				bool2 = true
				table.insert(nf2, name)
			end
		end
	end
	
	table.foreach(m, getNonFriend)
	
	return nf1, nf2, bool1, bool2

end

function getNonBuddies(merc)
	local m = Mercs
	local nb = {}
	local bool = false
	
	local getNonBuddy = function(name, data)
		if ((data.hired == true) and (data.alive == true)) then
			if (data.nonbuddy == merc) then
				bool = true
				table.insert(nb, name)
			end
		end
	end
	
	table.foreach(m, getNonBuddy)
	
	return nb, bool

end

function processEmo(list, reason, reaction)
	local log_id = "_emmo2000_"
	
	local process = function(index, name)
		local message = name.."_"..reaction.."_"..reason

		showComments(name, message, 0, 1, 1, 0)
	end
	
	table.foreach(list, process)
end

function emo2000(merc, reason)
	local log_id = "_emmo2000_"

	if (not(isValid(merc)) or not(isValid(reason))) then
		log(log_id, "INVALID PARAMS. Merc:", merc, "Reason:", reason)
		return
	end

	if (reason == "dies") then
		log(log_id, merc, reason)
		
		local friends1, friends2, hasFriends1, hasFriends2 = getFriends(merc)
		local buddies, hasBuddies = getBuddies(merc)
		local nonfriends1, nonfriends2, hasNonFriends1, hasNonFriends2  = getNonFriends(merc)
		local nonbuddies, hasNonBuddies = getNonBuddies(merc)
		
		if (hasFriends1 == true) then
			log(log_id, "> hasFriends1", hasFriends1)
			processEmo(friends1, reason, "friend_01")
		end
		if (hasNonFriends1 == true) then
			log(log_id, "> hasNonFriends1", hasNonFriends1)
			processEmo(nonfriends1, reason, "unfriendly_01")
		end
		if (hasFriends2 == true) then
			log(log_id, "> hasFriends2", hasFriends2)
			processEmo(friends2, reason, "friend_02")
		end
		if (hasNonFriends2 == true) then
			log(log_id, "> hasNonFriends2", hasNonFriends2)
			processEmo(nonfriends2, reason, "unfriendly_02")
		end
		if (hasBuddies == true) then
			log(log_id, "> hasBuddies", hasBuddies)
			processEmo(buddies, reason, "new_friend")
		end
		if (hasNonBuddies == true) then
			log(log_id, "> hasNonBuddies", hasNonBuddies)
			processEmo(nonbuddies, reason, "new_unfriendly")
		end
	elseif (reason == "good") then
		log(log_id, merc, "is", reason)
		
		local friends1, friends2, hasFriends1, hasFriends2 = getFriends(merc)
		local buddies, hasBuddies = getBuddies(merc)
		
		if (hasFriends1 == true) then
			log(log_id, "> hasFriends1", hasFriends1)
			processEmo(friends1, reason, "friend_01")
		end
		if (hasFriends2 == true) then
			log(log_id, "> hasFriends2", hasFriends2)
			processEmo(friends2, reason, "friend_02")
		end
		if (hasBuddies == true) then
			log(log_id, "> hasBuddies", hasBuddies)
			processEmo(buddies, reason, "new_friend")
		end
	elseif (reason == "hired") then
		log(log_id, merc, reason)
		
		local nonfriends1, nonfriends2, hasNonFriends1, hasNonFriends2  = getNonFriends(merc)

		if (hasNonFriends1 == true) then
			log(log_id, "> hasNonFriends1", hasNonFriends1)
			processEmo(nonfriends1, reason, "unfriendly_01")
		end
		if (hasNonFriends2 == true) then
			log(log_id, "> hasNonFriends2", hasNonFriends2)
			processEmo(nonfriends2, reason, "unfriendly_02")
		end
	else
		log(log_id, "Reason:", reason, "is unknown")
	end
end
